#include <stdio.h>
#include <kernel.h>
#include <osd_config.h>
#include <string.h>
#include <tamtypes.h>
#include <malloc.h>
#include <debug.h>


unsigned int CalculateValue(unsigned int a , unsigned int b) {
    
	return (unsigned int)( (0x0019660D * a) + 3 ) % b;
}



int CalculateAddress (int a){
	
	int b = a >> 0x1;
	
	a ^= ( a >> 0x5);
	a = (a << 0x16) & 0x00400000;

	return a | b;
}



int CalculateAddressRange (unsigned int a){
	
	int b = (a >> 0x4) & 1;

	a = a >> 22;
	b = b << 16;
	b++;
	
	return b + a;

}

int getIndex(unsigned int a) {
	
	int ret = CalculateAddressRange ( a );
	
	int b = (ret >> 16) << 3;
	return (ret & 0xFFFF) + b - 1;
	
}




int PerformRDRAMTest() {
	
	unsigned char *start;
	unsigned char *end;
	unsigned int range;
	unsigned int value;
    
	int r = 0x00400000;
	
	// The bits represent the status for different ranges of A/B.
	int RAMStatus = 0;
	
	
	int i = 0;
	int address;
	int index;
	
	unsigned char bufferA[8];
	unsigned char bufferB[8];
	
	i = 7;
	while(i >= 0 ) {
		bufferA[i] = 0;
		bufferB[i] = 0;
		i--;
	}
	
	
	start = memalign(0x10 , 0x10);
	free(start);
	
	range = 0x1FFC000 - (int)start - 0x10;
	
	/*
	
	In the original program memalign would continue to run until it finally manages to allocate the most highest possible range.
	This would allow to test as much RDRAM range as possible. 
	In our homebrew libraries malloc/memalign having a long range will return NULL (intended behaviour)
	But after trying to run it again with any range, it will stall. BUG?
	An arbitrary range is used as a workaround, very close to the one in TESTMODE ( ~ 30 MB).
	// Example: 0x00130590 to 0x01efe570

	while(1) {
		start = memalign( 0x10 ,  range);
		if(start != NULL) break;
		range -= 0x10;

	}
	*/
	
	range = 0x1DCDFE0;
	
	start = memalign( 0x10 ,  range);
	if(start == NULL) {
		scr_printf("Allocating RDRAM for testing failed!!\n");
		return 0;
	}
	
	
	end = start+range;
	
	scr_printf("RDRAM check: 0x%08X to 0x%08X | 0x%08X \n" , (int)start , (int)end,range );
	
	i = 0x7FFFFE;
	address = 1;
	value = 6;
	unsigned int add2;
	
	unsigned int startRange = (unsigned int)start & 0x1FFFFFFF;
	unsigned int endRange = startRange +  ( ( range>>0x2 ) << 0x2 );

	do {

		address = CalculateAddress(address);
		add2 = address << 0x2;

		if(  add2  >=  startRange  && endRange >= add2   ) {
			   value = CalculateValue(value , 0x10000000);
			   *(int*)add2 = value;
		}

		i--;
		
    } while( i != 0xFFFFFFFF );
	



	i = 0x7FFFFE;
	address = 1;
	value = 6;
	
	do {

		address = CalculateAddress(address);
		add2 = address << 0x2;

		if(  add2  >=  startRange  && endRange >= add2   ) {
			   value = CalculateValue(value , 0x10000000);
			   
			   if( *(int*)add2 != value ) {
				   
				   index = getIndex( add2 );
				   
				   if(index < 8) bufferA[index]++;
				    else
					   bufferB[index-8]++;


			   }

		}

		i--;
		
    } while( i != 0xFFFFFFFF );
	

	
	scr_printf("+----------+----------+\n");
	scr_printf("|   Ch.A   |   Ch.B   |\n");
	scr_printf("+----------+----------+ 0x00000000\n");
	
	
	for( i=0; i < 8; i++ ) {
		
		scr_printf("|    ");
		
		if (bufferA[i] == 0) {
			scr_printf("OK    |    ");
		}
		else{
			scr_printf("NG    |    ");
			RAMStatus += 1 << i;
		}
			
		
		if (bufferB[i] == 0) {
			scr_printf("OK    |\n");
		}
		else{
			scr_printf("NG    |\n");
			RAMStatus += 0x10000000 << i;
		}	

		
		scr_printf("+----------+----------+ 0x%08X\n" , r );
		r += 0x00400000;
		
	}
	

	if(  (RAMStatus & 0xFFFF) == 0 )  scr_printf("RDRAM A ch:OK\n");
		else
			scr_printf("RDRAM A ch:NG\n");
	
	
	if( (RAMStatus & 0xFFFF0000) == 0 )  scr_printf("RDRAM B ch:OK\n");
		else
			scr_printf("RDRAM B ch:NG\n");
	
	
	free(start);
	
	
	return RAMStatus;
	
}


int main(int argc, char *argv[]) {
   

    ee_kmode_enter();

    init_scr();

    ee_kmode_enter();

	scr_printf(" \n");
	scr_printf(" \n");
	
    scr_printf("PS2 RDRAM TEST (BASED ON TESTMODE ) krat0s\n");
	
	scr_printf("Please wait while checking PS2 RDRAM.\n");
	scr_printf("It can take from 30 seconds to a minute.\n");
	
	PerformRDRAMTest();
	
	scr_printf("Finished. \n");
    SleepThread();
    
	
    return 0;
 
}
